import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class TestAverage extends JFrame
{
   // Deklarujemy komponenty
   private JLabel test1Label;
   private JLabel test2Label;
   private JLabel test3Label;
   private JLabel resultLabel;
   private JLabel averageLabel;
   
   private JTextField test1TextField;
   private JTextField test2TextField;
   private JTextField test3TextField;
   
   private JButton calcButton;
   private JButton exitButton;
   
   private JPanel panel1;
   private JPanel panel2;
   private JPanel panel3;
   private JPanel panel4;
   private JPanel panel5;
   
   // Konstruktor
   public TestAverage()
   {
      // Wyświetlamy napis na pasku tytułowym.
      setTitle("Średni wynik ze sprawdzianów");
      
      // Określamy, co ma się stać po kliknięciu przycisku zamknięcia okna
      setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      
      // Tworzymy etykiety
      test1Label = new JLabel("Wynik ze sprawdzianu nr 1:");
      test2Label = new JLabel("Wynik ze sprawdzianu nr 2:");
      test3Label = new JLabel("Wynik ze sprawdzianu nr 3:");
      resultLabel = new JLabel("Średni wynik");
      averageLabel = new JLabel("");
      
      // Tworzymy pola tekstowe
      test1TextField = new JTextField(10);
      test2TextField = new JTextField(10);
      test3TextField = new JTextField(10);
      
      // Tworzymy przyciski
      calcButton = new JButton("Oblicz średni wynik");
      exitButton = new JButton("Zakończ");
      
      // Rejestrujemy procedury obsługi zdarzeń dla przycisków
      calcButton.addActionListener(new CalcButtonListener());
      exitButton.addActionListener(new ExitButtonListener());
      
      // Tworzymy pięć paneli, aby zaaranżować komponenty w oknie
      panel1 = new JPanel();
      panel2 = new JPanel();
      panel3 = new JPanel();
      panel4 = new JPanel();
      panel5 = new JPanel();
      
      // Dodajemy określone komponenty do panelu panel1
      panel1.add(test1Label);
      panel1.add(test1TextField);
      
      // Dodajemy określone komponenty do panelu panel2
      panel2.add(test2Label);
      panel2.add(test2TextField);

      // Dodajemy określone komponenty do panelu panel3
      panel3.add(test3Label);
      panel3.add(test3TextField);
      
      // Dodajemy określone komponenty do panelu panel4
      panel4.add(resultLabel);
      panel4.add(averageLabel);

      // Dodajemy określone komponenty do panelu panel5
      panel5.add(calcButton);
      panel5.add(exitButton);
      
      setLayout(new GridLayout(5, 1));
      
      // Dodajemy wszystkie panele do okna
      add(panel1);
      add(panel2);
      add(panel3);
      add(panel4);
      add(panel5);
      
      // Sprawiamy, że okno staje się widoczne
      pack();
      setVisible(true);
   }
   
   public class CalcButtonListener implements ActionListener
   {
      // Ta metoda zostanie wywołana po kliknięciu przycisku calcButton
      public void actionPerformed(ActionEvent e)
      {
         // Deklarujemy zmienne, w których zapiszemy
         // wyniki ze sprawdzianów i średni wynik
         double test1, test2, test3, average;
         
         // Pobieramy wynik z pierwszego sprawdzianu
         test1 = Double.parseDouble(test1TextField.getText());
         
         // Pobieramy wynik z drugiego sprawdzianu
         test2 = Double.parseDouble(test2TextField.getText());

         // Pobieramy wynik z trzeciego sprawdzianu
         test3 = Double.parseDouble(test3TextField.getText());
         
         // Obliczamy średni wynik
         average = (test1 + test2 + test3) / 3;
         
         // Wyświetlamy średni wynik ze sprawdzianów
         // w etykiecie averageLabel
         averageLabel.setText(Double.toString(average));
      }
   }

   public class ExitButtonListener implements ActionListener
   {
      // Ta metoda zostanie wywołana po kliknięciu przycisku exitButton
      public void actionPerformed(ActionEvent e)
      {
         // Zamykamy aplikację
         System.exit(0);
      }
   }
   
   // Metoda main to punkt startowy programu
   public static void main(String[] args)
   {
      // Tworzymy instancję klasy TestAverage
      new TestAverage();
   }
}